//
//  CRStackingPanel.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 11/12/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRItemsCollectionView.h"

//////////////////////////////////////////////////////////////////////
// CRStackingPanelDelegate
//////////////////////////////////////////////////////////////////////
@protocol CRStackingPanelDelegate
@optional

- (BOOL)viewIsSizable:(NSView *)view;

@end


//////////////////////////////////////////////////////////////////////
// CRStackingPanel
//////////////////////////////////////////////////////////////////////
@interface CRStackingPanel : CRCollectionViewItemBase
{
	NSMutableArray* content;
	NSTimeInterval	animationDuration;
	BOOL			wantsAnimation;
	BOOL			fitToSize;
	BOOL			adjustSizeByRequest;
	NSSize			minimumSize;
	NSSize			maximumSize;
	NSSize			requestedSize;
}

@property (nonatomic, readonly) NSArray*		content;
@property (nonatomic, assign)	NSTimeInterval	animationDuration;
@property (nonatomic, assign)	BOOL			wantsAnimation;
@property (nonatomic, assign)	BOOL			fitToSize;
@property (nonatomic, assign)	BOOL			adjustSizeByRequest;
@property (nonatomic, assign)	NSSize			minimumSize;
@property (nonatomic, assign)	NSSize			maximumSize;
@property (nonatomic, readonly)	NSSize			requestedSize;

// special delegate
@property (nonatomic, assign)	id<CRStackingPanelDelegate> panelDelegate;

- (void)layout;

- (void)addContent:(NSView *)view;
- (void)insertContent:(NSView *)view atIndex:(NSInteger)index;
- (void)removeContent:(NSView *)view;
- (void)removeContentAtIndex:(NSInteger)index;
- (void)removeAllContent;
- (void)replaceContent:(NSView *)oldView withView:(NSView *)newView;

- (void)toggleContent:(NSView *)view;
- (void)toggleContentItems:(NSArray *)items;

@end